/*
 * Decompiled with CFR 0.152.
 */
package technology.rocketjump.undermount.mapgen.calculators;

import com.badlogic.gdx.ai.msg.PriorityQueue;
import com.badlogic.gdx.math.GridPoint2;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import technology.rocketjump.undermount.mapgen.calculators.model.GridPoint2PathfindingNode;
import technology.rocketjump.undermount.mapgen.calculators.model.Map2DCollection;
import technology.rocketjump.undermount.mapgen.model.output.GameMap;
import technology.rocketjump.undermount.mapgen.model.output.GameMapTile;

public class RiverPathfindingCalculator {
    private final GridPoint2 origin;
    private final GameMapTile originTile;
    private final GridPoint2 destination;
    private final GameMap map;
    private final PriorityQueue<GridPoint2PathfindingNode> frontier = new PriorityQueue();
    private final Map2DCollection<GridPoint2PathfindingNode> explored;

    public RiverPathfindingCalculator(GridPoint2 origin, GridPoint2 destination, GameMap map) {
        this.map = map;
        this.explored = new Map2DCollection(map.getWidth());
        this.origin = origin;
        this.originTile = map.get(origin);
        this.destination = destination;
    }

    public List<GridPoint2> findPath() {
        ArrayList<GridPoint2> path = new ArrayList<GridPoint2>();
        if (this.origin.equals(this.destination)) {
            path.add(this.destination);
            return path;
        }
        this.frontier.add(new GridPoint2PathfindingNode(this.origin, 0.0f, null, this.destination.dst(this.origin)));
        while (this.frontier.size() > 0) {
            this.processNode(this.frontier.poll());
        }
        GridPoint2PathfindingNode nodeToNavigateVia = this.explored.get(this.destination);
        if (nodeToNavigateVia != null) {
            nodeToNavigateVia.setWorldPosition(this.destination);
        }
        while (nodeToNavigateVia != null) {
            path.add(nodeToNavigateVia.getWorldPosition());
            nodeToNavigateVia = nodeToNavigateVia.getPreviousNodeInPath();
        }
        Collections.reverse(path);
        return path;
    }

    private void processNode(GridPoint2PathfindingNode node) {
        GameMapTile nodeTile = this.map.get(node.getWorldPosition());
        if (nodeTile.equals(this.destination)) {
            this.frontier.clear();
        } else {
            for (GameMapTile neighbour : this.map.getOrthogonalNeighbours(node.getWorldPosition())) {
                if (!neighbour.isNavigableByRiver()) continue;
                float newCostToGetHere = node.getCostToGetHere() + this.getCost(nodeTile, neighbour);
                GridPoint2PathfindingNode previouslyExploredNode = this.explored.get(neighbour.getPosition());
                if (previouslyExploredNode != null && !(previouslyExploredNode.getCostToGetHere() > newCostToGetHere)) continue;
                GridPoint2PathfindingNode nextNode = new GridPoint2PathfindingNode(neighbour.getPosition(), newCostToGetHere, node, neighbour.getPosition().dst(this.destination));
                this.explored.add(neighbour.getPosition().x, neighbour.getPosition().y, nextNode);
                this.frontier.add(nextNode);
            }
        }
    }

    private float getCost(GameMapTile start, GameMapTile end) {
        float heightDifference = end.getHeightMapValue() - start.getHeightMapValue();
        if (heightDifference > 0.0f) {
            heightDifference *= 3.0f;
        }
        return 1.0f + heightDifference * 1000.0f;
    }

    private int calculateMaxNodesToExplore(GameMap map) {
        return 2 * map.getWidth() + map.getHeight();
    }
}

